/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor;

import com.quantumdata.fmteditor.FmtEditorMain;
import com.quantumdata.fmteditor.FmtUI;
import com.quantumdata.fmteditor.fmtwidgets.FmtFrameBase;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDList;
import com.quantumdata.widgets.QDListItem;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDToggleButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class MsgLogFrame
extends FmtFrameBase
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int ERR_MSG = 0;
    private static final int WARN_MSG = 1;
    private static final int PLAIN_MSG = 2;
    private QDList m_msgList;
    private FmtEditorMain m_mainWin;
    private boolean[] m_enabled = new boolean[3];

    public MsgLogFrame(FmtEditorMain fmtEditorMain) {
        super("Message Log", true, true, true, true);
        this.m_mainWin = fmtEditorMain;
        this.setLayout(new BorderLayout());
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        QDPanel qDPanel2 = new QDPanel();
        qDPanel2.add((Component)new QDLabel("Show: "));
        qDPanel2.add((Component)this.makeBtn(0, FmtUI.getIcon(2), true));
        qDPanel2.add((Component)this.makeBtn(1, FmtUI.getIcon(1), true));
        qDPanel2.add((Component)this.makeBtn(2, FmtUI.getIcon(0), false));
        qDPanel.add((Component)qDPanel2);
        QDButton qDButton = new QDButton("Clear");
        qDButton.addActionListener((ActionListener)this);
        qDPanel.add((Component)qDButton, (Object)"East");
        this.add((Component)qDPanel, "North");
        this.m_msgList = new QDList();
        this.add(new JScrollPane((Component)this.m_msgList), "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.clear();
        this.m_mainWin.errorCleared();
    }

    private JToggleButton makeBtn(int n, Icon icon, boolean bl) {
        QDToggleButton qDToggleButton = new QDToggleButton("", icon);
        qDToggleButton.addActionListener((ActionListener)new FilterToggle(n));
        qDToggleButton.setFocusable(false);
        qDToggleButton.setSelected(bl);
        this.m_enabled[n] = bl;
        return qDToggleButton;
    }

    public void clear() {
        this.m_msgList.getData().clear();
    }

    public void addError(String string) {
        if (this.m_enabled[0]) {
            this.m_msgList.getData().addElement(new QDListItem(string, FmtUI.getIcon(2)));
        }
    }

    public void addWarning(String string) {
        if (this.m_enabled[1]) {
            this.m_msgList.getData().addElement(new QDListItem(string, FmtUI.getIcon(1)));
        }
    }

    public void addMsg(String string) {
        if (this.m_enabled[2]) {
            this.m_msgList.getData().addElement(new QDListItem(string, FmtUI.getIcon(0)));
        }
    }

    public String getDataName() {
        return "";
    }

    public String getTypeName() {
        return "Message Log";
    }

    public boolean isSaveable() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public void markUnmodified() {
    }

    public RemoteInstrument getInstrument() {
        return null;
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
    }

    public boolean isLocalFile() {
        return true;
    }

    public boolean supportsRemoteFiles() {
        return false;
    }

    private class FilterToggle
    implements ActionListener {
        private int m_index;

        public FilterToggle(int n) {
            this.m_index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            ((MsgLogFrame)MsgLogFrame.this).m_enabled[this.m_index] = jToggleButton.isSelected();
        }
    }
}

